#include "vtk.hh"

main ()
{
  vtkRenderMaster rm;
  vtkRenderWindow *renWin=rm.MakeRenderWindow();
  vtkRenderer *aren=renWin->MakeRenderer();
  vtkRenderWindowInteractor *iren=renWin->MakeRenderWindowInteractor();

  // create pipeline
  vtkVolume16Reader v16;
    v16.SetDataDimensions(128,128) ;
    v16.SwapBytesOn();
    v16.SetFilePrefix("headsq/half");
    v16.SetImageRange(1,93);
    v16.SetDataAspectRatio(1.6,1.6,1.5);

  vtkMarchingCubes iso;
    iso.SetInput(v16.GetOutput());
    iso.SetValue(0,1150);

  vtkPolyMapper isoMapper;
    isoMapper.SetInput(iso.GetOutput());
    isoMapper.ScalarsVisibleOff();

  vtkActor isoActor;
    isoActor.SetMapper(isoMapper);
    isoActor.GetProperty()->SetColor(.98,.92,.84);

  // outline the dataset
  vtkOutlineFilter outline;
    outline.SetInput(v16.GetOutput());

  vtkPolyMapper outlineMapper;
    outlineMapper.SetInput(outline.GetOutput());

  vtkActor outlineActor;
    outlineActor.SetMapper(outlineMapper);
    outlineActor.GetProperty()->SetColor(0,0,0);

  // render image
  aren->AddActors(&outlineActor);
  aren->AddActors(&isoActor);
  aren->SetBackground(.1,.2,.4);

  renWin->Render();

  // interact with data
  iren->Start();
}

